<?php

namespace Database\Seeders;

use App\Models\Course;
use App\Models\Category;
use App\Enums\DefineStatus;
use Illuminate\Database\Seeder;

class CourseSeeder extends Seeder
{
    public function run(): void
    {
        $courses = [
            [
                'category_id'             => Category::where('name', 'A0/A1')->first()->id,
                'title'                   => 'Course A0/A1',
                'image'                   => 'https://placehold.co/800x600/png?text=English+Vision+A0/A1',
                'price'                   => 4500,
                'description'             => 'Description for A0/A1 course',
                'preview_video'           => 'https://youtu.be/ZZHVKw-djZ0?si=3rkBQqbyKl1fBms1',
                'preview_video_thumbnail' => 'https://img.youtube.com/vi/ZZHVKw-djZ0/sddefault.jpg',
                'status'                  => DefineStatus::ACTIVE->value,
                'sessions_count'          => 24,
                'duration'                => 120,
                'what_you_will_learn'     => json_encode([
                    'Learn basic English vocabulary',
                    'Master simple grammar structures',
                    'Develop elementary conversation skills',
                    'Understand common everyday phrases',
                    'Build a foundation for further language learning'
                ]),
                'learning_plan' => 'https://www.ulethbridge.ca/sites/default/files/docs/LearningPlanSample.pdf',
            ],
            [
                'category_id'             => Category::where('name', 'A2')->first()->id,
                'title'                   => 'Course A2',
                'image'                   => 'https://placehold.co/800x600/png?text=English+Vision+A2',
                'price'                   => 5000,
                'description'             => 'Description 2',
                'preview_video'           => 'https://youtu.be/ZZHVKw-djZ0?si=3rkBQqbyKl1fBms1',
                'preview_video_thumbnail' => 'https://img.youtube.com/vi/ZZHVKw-djZ0/sddefault.jpg',
                'status'                  => DefineStatus::ACTIVE->value,
                'sessions_count'          => 30,
                'duration'                => 150,
                'what_you_will_learn'     => json_encode([
                    'Expand your English vocabulary',
                    'Improve grammar understanding',
                    'Enhance conversation abilities',
                    'Practice everyday communication',
                    'Develop reading and writing skills'
                ]),
                'learning_plan' => 'https://www.ulethbridge.ca/sites/default/files/docs/LearningPlanSample.pdf',
            ],
            [
                'category_id'             => Category::where('name', 'B1')->first()->id,
                'title'                   => 'Course B1',
                'image'                   => 'https://placehold.co/800x600/png?text=English+Vision+B1',
                'price'                   => 5500,
                'description'             => 'Description 3',
                'preview_video'           => 'https://youtu.be/ZZHVKw-djZ0?si=3rkBQqbyKl1fBms1',
                'preview_video_thumbnail' => 'https://img.youtube.com/vi/ZZHVKw-djZ0/sddefault.jpg',
                'status'                  => DefineStatus::ACTIVE->value,
                'sessions_count'          => 36,
                'duration'                => 180,
                'what_you_will_learn'     => json_encode([
                    'Master intermediate vocabulary',
                    'Apply complex grammar structures',
                    'Engage in fluent conversations',
                    'Understand native speakers',
                    'Express opinions on various topics'
                ]),
                'learning_plan' => 'https://www.ulethbridge.ca/sites/default/files/docs/LearningPlanSample.pdf',
            ],
            [
                'category_id'             => Category::where('name', 'B2')->first()->id,
                'title'                   => 'Course B2',
                'image'                   => 'https://placehold.co/800x600/png?text=English+Vision+B2',
                'price'                   => 6000,
                'description'             => 'Description 4',
                'preview_video'           => 'https://youtu.be/ZZHVKw-djZ0?si=3rkBQqbyKl1fBms1',
                'preview_video_thumbnail' => 'https://img.youtube.com/vi/ZZHVKw-djZ0/sddefault.jpg',
                'status'                  => DefineStatus::ACTIVE->value,
                'sessions_count'          => 42,
                'duration'                => 210,
                'what_you_will_learn'     => json_encode([
                    'Master advanced vocabulary',
                    'Apply sophisticated grammar',
                    'Engage in complex conversations',
                    'Understand cultural nuances',
                    'Express nuanced opinions'
                ]),
                'learning_plan' => 'https://www.ulethbridge.ca/sites/default/files/docs/LearningPlanSample.pdf',
            ],
              // 'C1'
            [
                'category_id'             => Category::where('name', 'C1')->first()->id,
                'title'                   => 'Course C1',
                'image'                   => 'https://placehold.co/800x600/png?text=English+Vision+C1',
                'price'                   => 6500,
                'description'             => 'Description 5',
                'preview_video'           => 'https://youtu.be/ZZHVKw-djZ0?si=3rkBQqbyKl1fBms1',
                'preview_video_thumbnail' => 'https://img.youtube.com/vi/ZZHVKw-djZ0/sddefault.jpg',
                'status'                  => DefineStatus::ACTIVE->value,
                'sessions_count'          => 48,
                'duration'                => 240,
                'what_you_will_learn'     => json_encode([
                    'Master advanced vocabulary',
                    'Apply sophisticated grammar',
                    'Engage in complex conversations',
                    'Understand cultural nuances',
                    'Express nuanced opinions'
                ]),
                'learning_plan' => 'https://www.ulethbridge.ca/sites/default/files/docs/LearningPlanSample.pdf',
            ],
              // 'C2'
            [
                'category_id'             => Category::where('name', 'C2')->first()->id,
                'title'                   => 'Course C2',
                'image'                   => 'https://placehold.co/800x600/png?text=English+Vision+C2',
                'price'                   => 7000,
                'description'             => 'Description 6',
                'preview_video'           => 'https://youtu.be/ZZHVKw-djZ0?si=3rkBQqbyKl1fBms1',
                'preview_video_thumbnail' => 'https://img.youtube.com/vi/ZZHVKw-djZ0/sddefault.jpg',
                'status'                  => DefineStatus::ACTIVE->value,
                'sessions_count'          => 54,
                'duration'                => 270,
                'what_you_will_learn'     => json_encode([
                    'Master advanced vocabulary',
                    'Apply sophisticated grammar',
                    'Engage in complex conversations',
                    'Understand cultural nuances',
                    'Express nuanced opinions'
                ]),
                'learning_plan' => 'https://www.ulethbridge.ca/sites/default/files/docs/LearningPlanSample.pdf',
            ],
        ];
        Course::insert($courses);
    }
}
