<?php

namespace Database\Seeders;

use App\Models\PlacementTestResult;
use App\Models\Question;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PlacementTestSeeder extends Seeder
{
    public function run(): void
    {
        $users = User::factory()->count(15)->create();
        foreach ($users as $user) {
            $questions = Question::with('options','category')->inRandomOrder()->limit(rand(20, 40))->get();
            $total = $questions->count();
            $correct = 0;
            $levels = [];

            foreach ($questions as $question) {
                $levelId = $question->category_id;
                if(!isset($levels[$levelId])){
                    $levels[$levelId] = [
                        'level_id' => $levelId,
                        'level' => $question->category->name ?? "Level $levelId",
                        'correct_answer_count' => 0,
                        'total_questions' => 0
                    ];
                }

                $levels[$levelId]['total_questions']++;

                if (rand(0, 100) < 70) {
                    $correct++;
                    $levels[$levelId]['correct_answer_count']++;
                }
            }

            $maxLevel = null;
            $maxCorrectAnswers = 0;
            foreach($levels as $level){
                if($level['correct_answer_count'] > $maxCorrectAnswers){
                    $maxCorrectAnswers = $level['correct_answer_count'];
                    $maxLevel = $level['level_id'];
                }
            }

            PlacementTestResult::create([
                'user_id' => $user->id,
                'total_questions' => $total,
                'total_correct_answers' => $correct,
                'max_level_id' => $maxLevel,
                'percentage' => ($correct / $total) * 100,
                'levels' => array_values($levels),
            ]);
        }
    }
}
