<?php
namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Admin\ActivityLogController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\V1\FaqController;
use App\Http\Controllers\Api\V1\EnumController;
use App\Http\Controllers\Api\V1\HomeController;
use App\Http\Controllers\Api\V1\AdminController;
use App\Http\Controllers\Api\V1\RoundController;
use App\Http\Controllers\Api\V1\CouponController;
use App\Http\Controllers\Api\V1\CourseController;
use App\Http\Controllers\Api\V1\ReportController;
use App\Http\Controllers\Api\V1\LectureController;
use App\Http\Controllers\Api\V1\PaymentController;
use App\Http\Controllers\Api\V1\SettingController;
use App\Http\Controllers\Api\V1\StudentController;
use App\Http\Controllers\Api\V1\CategoryController;
// use App\Http\Controllers\Api\V1\ContactUsController;
use App\Http\Controllers\Api\V1\InstructorController;
use App\Http\Controllers\Api\V1\SupervisorController;
use App\Http\Controllers\Api\V1\NotificationController;
use App\Http\Controllers\Api\V1\RoundStudentController;
use App\Http\Controllers\Api\V1\LectureQuestionController;
use App\Http\Controllers\Api\V1\RoundSupervisorController;
use App\Http\Controllers\Api\V1\ZoomIntegrationController;
use App\Http\Controllers\Api\V1\CourseEnrollmentController;
use App\Http\Controllers\Api\V1\WhatsappTemplateController;
use App\Http\Controllers\Api\V1\Authentication\AuthController;
use App\Http\Controllers\Api\V1\ExpenseController;
use App\Http\Controllers\Api\V1\SubjectController;
use App\Http\Controllers\Api\V1\RoleController;
use App\Http\Controllers\Api\V1\TicketSystemController;
use App\Models\Round;

Route::controller(AuthController::class)->group(function () {
    Route::post('/login', 'login');
    Route::post('/logout', 'logout')->middleware('auth:sanctum');
});

Route::middleware(['auth:sanctum', 'isAdmin', 'log.activity'])->group(function () {


    Route::controller(SurveyController::class)->prefix('surveys')->group(function(){
        Route::get('/', 'index');
        Route::get('/{survey:slug}', 'show');
        Route::get('/{survey:slug}/responses', 'responses');
    });

    // Subject Routes
    Route::apiResource('subjects', SubjectController::class);

    Route::post('add/bonus',[StudentController::class,'addBonus']);

    Route::post('add/skills/{course}',[CourseController::class,'addSkills']);
    Route::get('add/skills/{round}/students',[RoundController::class,'addSkillsStudents']);

    Route::controller(NoticeStudentController::class)->prefix('notices-students')->group(function () {
        Route::post('/', 'store');
        Route::put('/{noticeStudent}', 'update');
        Route::delete('/{noticeStudent}', 'destroy');
    });


    Route::controller(TicketSystemController::class)->prefix('tickets')->group(function(){
        Route::get('/','index');
        Route::get('/get-by-assign','getByAssignTo');
        Route::get('/{ticketSystem}','show');
        Route::post('/','store');
        Route::put('/{ticketSystem}','update');
        Route::delete('/{ticketSystem}','destroy');

        // Ticket Replies endpoints
        Route::post('{ticketSystem}/change-status','changeTicketStatus');
        Route::post('{ticketSystem}/assign','assignTicket');
        Route::get('/{ticket_id}/replies','getReplies');
        Route::post('/{ticket_id}/replies','storeReply');
        Route::put('/{ticket_id}/replies/{reply_id}','updateReply');
        Route::delete('/{ticket_id}/replies/{reply_id}','destroyReply');

        Route::get('/get/statistics','statistics');

    });

    Route::get('notices-absents', [LectureController::class,'getAllNoticeAbsent']);
    Route::controller(LectureController::class)->prefix('lectures')->group(function () {
        Route::post('{lecture}/notices-absents', 'storeNoticeAbsent');
        Route::put('notices-absents/{noticeAbsent}', 'updateNoticeAbsent');
        Route::delete('notices-absents/{noticeAbsent}', 'destroyNoticeAbsent');
    });


    Route::get('task/feedbacks',[FeedbackController::class,'taskFeedbacks']);
    Route::apiResource('reviews',ReviewController::class)->except('show');
    Route::get('lecture/{lecture}/reviews',[ReviewController::class,'show']);

    Route::apiResource('topics',TopicController::class);
    Route::get('/{id}/{model}/move-up', [OrderController::class, 'moveUp']);
    Route::get('/{id}/{model}/move-down', [OrderController::class, 'moveDown']);

    Route::apiResource('roles',RoleController::class);
    Route::get('permissions', [RoleController::class, 'getPermission']);

    #----- Placement Test Routes
    Route::apiResource('/placement-test', PlacementTestController::class);
    Route::get('/placement-test-results', [PlacementTestController::class, 'results']);

    #----- Category Routes
    Route::apiResource('/categories', CategoryController::class);

    #----- Course Routes
    Route::post('course-content/{course}',[CourseController::class,'storeCourseContent']);
    Route::apiResource('/courses', CourseController::class);

    #----- Round Routes
    Route::apiResource('/rounds', RoundController::class);
    Route::get('round/{round}/group-report',[RoundController::class,'getGroupReport']);
    // payments//
    Route::prefix('payments')->group(function () {
        Route::get('/', [PaymentController::class, 'roundsPayments']);
    });

    #----- Lecture Routes
    Route::apiResource('/lectures', LectureController::class);
    Route::apiResource('/free-materials', FreeMaterialController::class);

    Route::get('/arab-countries', [ArabCountryController::class, 'arabCountry']);
    Route::get('/governorates/{country}', [ArabCountryController::class, 'governorates']);
    Route::get('/colleges', [ArabCountryController::class, 'colleges']);

    Route::get('download/excel-demo', function(){
        return response()->download(public_path('test_users_import.xlsx'));
    });
    Route::apiResource('payment-methods', PaymentMethodController::class);
    Route::apiResource('installments', InstallmentController::class);
    Route::post('change/status/installments/{installment}',[InstallmentController::class,'changeStatus'])->name('change.status.installments');
    Route::get('round/installments/{round}',[InstallmentController::class,'getInstallmentsByRound']);
    Route::apiResource('transactions', Transaction2Controller::class);
    Route::post('course-enrollment/{course_enrollment}', [CourseEnrollmentController::class,'updateEnrollment'])->name('update.course.enrollment');
    Route::get('course-enrollments/{round}', [CourseEnrollmentController::class,'getCourseEnrollmentsByRound'])->name('course.enrollments.round');
    Route::delete('course-enrollment/{course_enrollment}', [CourseEnrollmentController::class,'destroy'])->name('delete.course.enrollment');

    Route::apiResource('expenses', ExpenseController::class);
    Route::apiResource('expense-categories', ExpenseCategoryController::class);
    #----- Course Enrollment Routes
    Route::get('/course-enrollments', [CourseEnrollmentController::class, 'index']);
    Route::post('/course-enrollments', [CourseEnrollmentController::class, 'store']);
    Route::post('change/status/enrollments/{enrollment}',[CourseEnrollmentController::class,'changeStatus'])->name('change.status.enrollments');

    Route::delete('lectures/tasks/feedback/{feedback}', [LectureController::class,'destroyTaskFeedback']);
    Route::post('lectures/tasks/feedback/{taskFeedback}',[LectureController::class ,'updateFeedback']);
    Route::controller(LectureController::class)->prefix('lectures/{lecture}')->group(function () {
        Route::get('/tasks', 'getSubmissionsForReview');
        Route::post('/tasks/{task?}', 'gradeSubmission');
        Route::post('/tasks/{task}/feedback', 'storeFeedback');
        Route::post('/zoom/create-meeting', 'addMeetingToLecture');
        Route::get('/recordings', 'getLectureRecordings');
    });

    #----- FAQ Routes
    Route::apiResource('/faqs', FaqController::class);
    Route::apiResource('/branches', BrancheController::class);


    Route::prefix(('statistics'))->group(function () {
        Route::get('expenses', [ExpenseController::class, 'getExpensesStatistics']);
        Route::get('transactions', [Transaction2Controller::class, 'getTransactionsStatistics']);
    });

    Route::controller(NoticeController::class)->group(function () {
        Route::post('/notices', 'store');
        Route::delete('notices/{notice}', 'destroy');
    });


    Route::apiResource('lecture-videos',LectureVideoController::class);


    #----- Related To Round Routes
    Route::prefix('rounds')->group(function () {

        Route::get('{round}/stats',[RoundController::class,'getStats']);
        Route::post('/{round}/round/content',[RoundController::class,'editRoundContent']);
        Route::get('{round}/merage/content',[RoundController::class,'mergeContent']);
        Route::post('{round}/add-link', [RoundController::class, 'addLinkToRound']);

        Route::post('export/students',[RoundController::class,'exportStudents'])->name('export.students');
        Route::post('import/students',[RoundController::class,'importStudents'])->name('import.students');

        Route::get('/{round}/lectures', [RoundController::class, 'lectures']);
        // Route::post('/{round}/lectures/{lecture}/zoom/create-meeting', [ZoomIntegrationController::class, 'createMeeting']);
        //
        Route::controller(RoundSupervisorController::class)->group(function () {
            Route::post('/add-supervisors', 'addSupervisor');
            Route::post('/add-round', 'addRoundToSupervisors');
            Route::post('/{round}/supervisor/{supervisor}/change-status', 'changeSupervisorStatus');
            Route::get('/{round}/supervisors', 'showSupervisorsInRound');
        });


        Route::controller(RoundStudentController::class)->group(function () {
            Route::post('/add-students', 'addStudent');
            Route::post('/move-students', 'moveStudent');
            Route::get('/{round}/students', 'showStudentsInRound');
            Route::post('/students/unenrolled', 'unenrolledStudents');
            Route::post('/{round}/student/{user}/change-status', 'changeStudentStatus');
            Route::delete('/{round}/student/{user}/delete', 'rmStudentFromRound');
        });


            Route::controller(EvaluationController::class)->prefix('/{round}')->group(function () {
                Route::get('/lectures/{lecture}/evaluations', 'getEvaluationByLecture');
                Route::post('/lectures/{lecture}/attendance', 'storeStudentAttendance');
                Route::post('/lectures/{lecture}/evaluations', 'storeStudentEvaluation');
                Route::post('/student/{student}/evaluations/add-points', 'storeStudentPoints');
            });

        //
        //     Route::controller(TransactionController::class)->prefix('/{round}/students')->group(function () {
        //         Route::post('/{user}/transaction', 'storeStudentTransaction');
        //         Route::get('/{userId}/show-transaction', 'showStudentTransaction');
        //     });
    });

    #----- Reports Routes
    Route::prefix('reports')->controller(ReportController::class)->group(function () {
        Route::get('/counts', 'counts');
        Route::get('/rounds', [ReportController::class, 'roundsReport']);
        Route::get('/students', 'studentsReport');
        Route::get('/courses', 'coursesReport');
        Route::get('group-report/{round}', 'getGroupReport');
        Route::get('student-report/{studentId}', 'getStudentReport');
    });


    #----- Instructor Routes
    Route::apiResource('instructors', InstructorController::class);

    #----- Student Routes
    Route::get('clients',[StudentController::class,'client']);
    Route::apiResource('students', StudentController::class);
    Route::post('students/enrolled', [StudentController::class, 'enrolledStudents']);
    Route::post('change/change-placement-test-status',[StudentController::class,'changePlacementTestStatus']);
    Route::apiResource('placement-test-tags', PlacmentTestTagController::class);


    #----- Supervisor Routes
    Route::apiResource('supervisors', SupervisorController::class);

    #----- Admin Routes
    Route::apiResource('admins', AdminController::class);

    #----- Setting Routes


    Route::prefix('home')->group(function () {
        Route::get('/statistics', [HomeController::class, 'showHomeStatistics']);
        Route::get('/recent', [HomeController::class, 'recentData']);
        Route::get('/top-selling', [HomeController::class, 'topSellingCourses']);
        Route::get('/user-distribution', [HomeController::class, 'ShowUserDistribution']);
        Route::get('/student-report', [HomeController::class, 'ShowStudentReport']);
        Route::get('/top-selling-report', [HomeController::class, 'topSellingCoursesReport']);
    });

    #----- Contact Us Routes
    // Route::apiResource('contact-us', ContactUsController::class);


    #----- Notification Routes
    Route::apiResource('notifications', NotificationController::class);
    Route::post('email-notification', [NotificationController::class,'sendEmailNotification']);
    Route::post('push-notification', [NotificationController::class,'sendPushNotification']);
    Route::post('read-mark-notification',[NotificationController::class,'readMarkNotification']);
    Route::get('read-notifications',[NotificationController::class,'getReadNotifications']);
    Route::get('unread-notifications',[NotificationController::class,'getUnreadNotifications']);


    #----- Whatsapp Template Routes
    Route::apiResource('whatsapp-templates', WhatsappTemplateController::class);

    //Enums Values
    Route::get('/enums/week-days', [EnumController::class, 'weekDays']);
    Route::apiResource('/lecture-tasks', LectureTaskController::class)->except(['show']);
    Route::get('/enums/payment-status', [EnumController::class, 'paymentStatus']);
    Route::get('/enums/define-status', [EnumController::class, 'defineStatus']);
    Route::get('/enums/user-type', [EnumController::class, 'userType']);
    Route::get('/enums/question-category', [EnumController::class, 'questionCategory']);
    Route::get('/enums/question-type', [EnumController::class, 'questionType']);
    //Lecture Question Routes
    Route::apiResource('lecture-questions', LectureQuestionController::class);
    Route::prefix('lecture')->group(function(){
        Route::apiResource('answers', LectureAnswerController::class)->except('index');
        Route::get('{lecture}/{user_id}/answers', [LectureAnswerController::class,'index']);
        Route::delete('answers/students/{id}', [LectureAnswerController::class, 'destroyForStudent']);
        Route::delete('answers/lectures/{id}', [LectureAnswerController::class, 'destroyAll']);
        Route::get('{lecture}/students', [LectureAnswerController::class,'studentAnswered']);
    });

    Route::prefix('lecture')->group(function(){
        Route::apiResource('grades', LectureGradeController::class)->except('index');
        Route::get('{lecture}/grades', [LectureGradeController::class,'index']);
    });

    //Whatsapp Campaigns Routes
    Route::apiResource('whatsapp-campaigns', SendWhatsAppCampaignsController::class)->only('store');


    //Coupon Routes
    Route::apiResource('coupons', CouponController::class);

    //Feedback Routes
    Route::get('feedbacks', [FeedbackController::class, 'index']);

    //Lecture Question Case Routes
    Route::get('lecture-question/cases', [LectureQuestionController::class, 'indexCases']);
    Route::post('lecture-questions/cases', [LectureQuestionController::class, 'createCase']);


    Route::get('activity-logs', [ActivityLogController::class, 'index'])->name('activity-logs.index');
    Route::get('activity-logs/json', [ActivityLogController::class, 'getLogsJson'])->name('activity-logs.json');
    Route::get('activity-logs/{activityLog}', [ActivityLogController::class, 'show'])->name('activity-logs.show');


});
Route::prefix('settings')->group(function () {
    Route::get('/', [SettingController::class, 'showSettings'])->withoutMiddleware('auth:sanctum');
    Route::post('/update', [SettingController::class, 'updateSettings'])->middleware('auth:sanctum');
});
