<?php
use App\Http\Controllers\Api\V1\ClientSide\LecturerLogController;
use App\Notifications\InvoicePaidMail;
use App\Services\GenerateInvoice;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\V1\SettingController;
use App\Http\Controllers\Api\V1\ClientSide\HomeController;
use App\Http\Controllers\Api\V1\ClientSide\CourseController;
use App\Http\Controllers\Api\V1\ClientSide\ProfileController;
use App\Http\Controllers\Api\V1\ClientSide\FeedbackController;
use App\Http\Controllers\Api\V1\ClientSide\LearningController;
use App\Http\Controllers\Api\V1\ClientSide\ContactUsController;
use App\Http\Controllers\Api\V1\ClientSide\MyLearningController;
use App\Http\Controllers\Api\V1\ClientSide\Payment\PaymentController;
use App\Http\Controllers\Api\V1\ClientSide\CourseEnrollmentController;
use App\Http\Controllers\Api\V1\ClientSide\FaqController;
use App\Http\Controllers\Api\V1\ClientSide\FawryController;
use App\Http\Controllers\Api\V1\ClientSide\LectureQuestionController;
use App\Http\Controllers\Api\V1\ClientSide\Notification\NotificationController;
use App\Http\Controllers\Api\V1\ClientSide\PlacementTestController;
use App\Http\Controllers\Api\V1\ClientSide\ReviewController;
use App\Http\Controllers\Api\V1\ClientSide\ScannerController;
use App\Http\Controllers\Api\V1\ClientSide\TopicController;
use App\Http\Controllers\Api\V1\ClientSide\SocialController;
#----- Placement Test Routes
Route::middleware('auth:sanctum')->group((function () {
    Route::get('/placement-test', [PlacementTestController::class,'index']);
    Route::post('/placement-test', [PlacementTestController::class,'checkAnswers']);
    Route::get('/placement-test-results', [PlacementTestController::class, 'results']);
}));


Route::controller(ScannerController::class)->prefix('qr')->middleware('auth:sanctum')->group(function(){
    Route::get('stats','stats');
    Route::post('scan','scan');
});


Route::post('pay',[FawryController::class,'pay'])->middleware('auth:sanctum');
Route::get('fmobile/payment', [FawryController::class, 'payUrl'])->name('fawry.mobile.payment.page');
Route::get('fawry/response',[FawryController::class,'response']);
Route::post('google/login',[SocialController::class,'google']);

Route::get('topics',[TopicController::class,'index'])->middleware('auth:sanctum');
Route::get('topics/{topic}/courses',[TopicController::class,'courses'])->middleware('auth:sanctum');
Route::get('free-materials',[TopicController::class,'freeMaterials'])->middleware('auth:sanctum');

Route::controller(CourseController::class)->middleware('auth:sanctum')->group(function () {
    Route::get('courses/{course}','show');
    Route::get('courses/{course}/user-sessions', 'getUserSessions');
});

Route::get('learning',LearningController::class)->middleware('auth:sanctum');
Route::get('learning/enrolled-courses/{course}',[MyLearningController::class,'show'])->middleware('auth:sanctum');

Route::controller(HomeController::class)->middleware('auth:sanctum')->group(function () {
    Route::get('home',HomeController::class);
});

Route::controller(CourseEnrollmentController::class)->middleware('auth:sanctum')->group(function () {
    Route::post('course-enrollment/enroll', 'enroll');
    Route::post('course-enrollment/check-coupon', 'checkCoupon');
});

Route::post('/payments/verify/{payment?}', [PaymentController::class, 'verifyWithPaymob'])->name('verify-payment');

Route::post('/contact-us', [ContactUsController::class, 'store'])->middleware('auth:sanctum');
Route::get('/settings', [SettingController::class, 'showSettings']);
Route::get('/settings/mobile', [SettingController::class, 'showSettingsApi']);


Route::prefix('user')->controller(ProfileController::class)->middleware('auth:sanctum')->group(function () {
    Route::get('/profile', 'show');
    Route::put('/profile', 'update');
});

Route::prefix('feedback')->controller(FeedbackController::class)->middleware('auth:sanctum')->group(function () {
    Route::post('/', 'store');
});


Route::prefix('/notifications')->middleware('auth:sanctum')->group(function () {
    Route::get('/', [NotificationController::class, 'allUserNotifications']);
    Route::get('/latest', [NotificationController::class, 'latestUserNotifications']);
    Route::get('/unread-count', [NotificationController::class, 'getUnReadNotificationCount']);
    Route::post('read-mark-notification',[NotificationController::class,'readMarkNotification']);
    Route::get('read-notifications',[NotificationController::class,'getReadNotifications']);
    Route::get('unread-notifications',[NotificationController::class,'getUnreadNotifications']);
});


Route::apiResource('reviews',ReviewController::class)->except('show')->middleware('auth:sanctum');
Route::get('lecture/{lecture}/reviews',[ReviewController::class,'show'])->middleware('auth:sanctum');

Route::post('lecture/logs',[LecturerLogController::class,'store'])->middleware('auth:sanctum');
Route::get('/faqs',[FaqController::class,'index'])->middleware('auth:sanctum');
Route::get('lecture-questions/{id}', [LectureQuestionController::class,'show'])->middleware('auth:sanctum');
Route::post('lecture-questions/answers', [LectureQuestionController::class,'answer'])->middleware('auth:sanctum');
Route::get('lecture-questions/{id}/grade', [LectureQuestionController::class,'gradeLecture'])->middleware('auth:sanctum');

// Route::get('test', function () {
//     $course = (object)[
//         'title' => 'Laravel Basics Course',
//     ];

//     $user = (object)[
//         'name' => 'Ahmed Hassan',
//         'address' => '123 Nile Street, Cairo',
//         'email' => 'ahmed@example.com',
//         'phone' => '+201234567890',
//     ];

//     $enrollment = (object)[
//         'id' => 1234,
//         'course' => $course,
//         'user' => $user,
//     ];

//     $paymentData = [
//         'transaction' => [
//             'amount_cents' => 7500,
//         ]
//     ];

//     $amount = $paymentData['transaction']['amount_cents'] / 100;

//     $invoiceService = new GenerateInvoice();
//     $invoicePath = $invoiceService
//         ->setCustomer([
//             'name' => $user->name,
//             'address' => $user->address ?? 'N/A',
//             'email' => $user->email,
//             'phone' => $user->phone ?? 'N/A',
//         ])
//         ->setSeller([
//             'name' => config('app.name', 'My App'),
//             'address' => config('app.address', 'Company Address'),
//             'email' => config('app.email', 'company@example.com'),
//             'phone' => config('app.phone', '987654321'),
//         ])
//         ->addItem(
//             $course->title,
//             $amount,
//             1
//         )
//         ->setLogo(config('app.logo', public_path('logo.png')))
//         ->setInvoiceNumber($enrollment->id)
//         ->saveToDisk('public', 'invoices')
//         ->save();

//     $notificationData = [
//         'title'   => 'Your Course Payment Receipt',
//         'message' => 'Your payment for ' . $course->title . ' has been processed successfully.',
//         'subject' => 'Payment Confirmation for ' . $course->title,
//     ];

//     auth()->user()?->notify(new InvoicePaidMail($invoicePath, $notificationData));

//     return 'Test completed with static data.';
// });
