<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Api\V1\Instructor\InstructorAuthController;
use App\Http\Controllers\Api\V1\Instructor\InstructorHomeController;
use App\Http\Controllers\Api\V1\Instructor\InstructorMessageController;
use App\Http\Controllers\Api\V1\Instructor\InstructorPaymentController;
use App\Http\Controllers\Api\V1\Instructor\InstructorProfileController;
use App\Http\Controllers\Api\V1\Instructor\InstructorRoundAttendanceController;
use App\Http\Controllers\Api\V1\Instructor\InstructorRoundController;
use App\Http\Controllers\Api\V1\Instructor\InstructorRoundTaskController;
use App\Http\Controllers\Api\V1\Instructor\InstructorTicketSystemController;

#----- Instructor Auth Routes
Route::controller(InstructorAuthController::class)->group(function () {
    Route::post('/login', 'login');
    Route::post('/logout', 'logout')->middleware(['auth:sanctum', 'isInstructor']);
});

Route::middleware(['auth:sanctum', 'isInstructor', 'log.activity'])->group(function () {

    #----- Instructor Profile Routes
    Route::controller(InstructorProfileController::class)->prefix('profile')->group(function () {
        Route::get('/', 'showProfile');
        Route::post('/update', 'updateProfile');
    });


    Route::controller(InstructorTicketSystemController::class)->prefix('tickets')->group(function(){
        Route::get('/get-by-assign','getByAssignTo');
        Route::get('/{ticketSystem}','show');
        Route::put('/{ticketSystem}','update');
        Route::delete('/{ticketSystem}','destroy');

        // Ticket Replies endpoints
        Route::post('{ticketSystem}/change-status','changeTicketStatus');
        Route::get('/{ticket_id}/replies','getReplies');
        Route::post('/{ticket_id}/replies','storeReply');
        Route::put('/{ticket_id}/replies/{reply_id}','updateReply');
        Route::delete('/{ticket_id}/replies/{reply_id}','destroyReply');

        Route::get('/get/statistics','statistics');

    });

    Route::get('get/projects',[InstructorRoundTaskController::class,'getProjects']);
    Route::post('accept/project/{project}',[InstructorRoundTaskController::class,'acceptProject']);

    Route::post('add/bonus',[InstructorRoundTaskController::class,'addBonus']);
    Route::get('add/skills/{round}/students',[InstructorRoundTaskController::class,'addSkillsStudents']);

    #----- Instructor Round Routes
    Route::controller(InstructorRoundController::class)->prefix('rounds')->group(function () {
        Route::post('/{round}/round/content','editRoundContent');
        Route::get('/', 'getInstructorRounds');
        Route::get('/{round}', 'getRoundsDetails');
        Route::get('/{round}/students', 'getRoundStudents');
    });

    Route::get('make-as-read/{round}',[InstructorRoundController::class,'makeAsRead']);
    #----- Instructor Round Task Routes
    Route::controller(InstructorRoundTaskController::class)->prefix('rounds')->group(function () {
        Route::post('/{round}/lectures/{lecture}/task/', 'addLectureTask');
        Route::post('/{round}/lectures/{lecture}/task/{lectureTask}', 'updateLectureTask');
        Route::get('/{round}/lectures/{lecture}/submissions', 'taskSubmissions');
        Route::post('/{round}/lectures/{lecture}/tasks/{task?}', 'gradeSubmission');
        Route::post('/{round}/lectures/{lecture}/tasks-gradeAll', 'gradeSubmissionAll');
        Route::get('/{round}/lectures/{lecture}/tasks/{task}', 'getFeedback');
        Route::post('/{round}/lectures/{lecture}/tasks/{task}/feedback', 'storeFeedback');
    });
    Route::post('lectures/tasks/feedback/{taskFeedback}', [InstructorRoundTaskController::class,'updateFeedback']);
    Route::delete('lectures/tasks/delete/feedback/{taskFeedback}', [InstructorRoundTaskController::class,'destroyTaskFeedback']);

    #----- Instructor Round Attendance Routes
    Route::controller(InstructorRoundAttendanceController::class)->prefix('rounds')->group(function () {
        Route::post('/{round}/lectures/{lecture}/attendance', 'storeStudentAttendance');
        Route::post('/{round}/lectures/{lecture}/evaluations', 'storeStudentEvaluation');
    });

    #----- Instructor Message Routes
    Route::post('rounds/{round}/send-message', [InstructorMessageController::class, 'sendMessage']);

    #----- Instructor Payment Route
    Route::get('/payments', [InstructorPaymentController::class, 'allReceivedPayments']);

    #----- Instructor Home Routes
    Route::controller(InstructorHomeController::class)->prefix('home')->group(function () {
        Route::get('/statistics', 'showHomeStatistics');
        Route::get('/top-students', 'getTopStudentPerRound');
        Route::get('/upcoming-meetings', 'InstructorUpcomingMeetings');
    });

});
