<?php

use App\Http\Controllers\Api\V1\Student\ProfileLinkController;
use App\Http\Controllers\Api\V1\Student\ProjectController;
use App\Http\Controllers\Api\V1\Student\SkillController;
use App\Http\Controllers\Api\V1\Student\StudentAuthController;
use App\Http\Controllers\Api\V1\Student\StudentEnrollmentController;
use App\Http\Controllers\Api\V1\Student\StudentHomeController;
use App\Http\Controllers\Api\V1\Student\StudentMeetingController;
use App\Http\Controllers\Api\V1\Student\StudentProfileController;
use App\Http\Controllers\Api\V1\Student\StudentTicketController;
use App\Http\Controllers\Api\V1\Student\StudentTransactionController;
use App\Http\Controllers\Api\V1\Student\FreeMaterialController;
use App\Http\Controllers\Api\V1\Student\SurveyController;
use App\Http\Controllers\Api\V1\Student\TicketSystemController;
use Illuminate\Support\Facades\Route;



#----- Student Auth Routes
Route::controller(StudentAuthController::class)->group(function () {
    Route::post('/login', 'login');
    Route::post('/logout', 'logout')->middleware(['auth:sanctum', 'isStudent']);
});

Route::middleware(['auth:sanctum', 'isStudent', 'log.activity'])->group(function () {


    Route::controller(SurveyController::class)->prefix('surveys')->group(function () {
        Route::get('/', 'index');
        Route::get('/{survey:slug}', 'show');
        Route::post('/{survey:slug}/answer', 'publicSurveyAnswer');
        Route::get('/{survey:slug}/responses', 'responses');
    });

    Route::apiResource('skills', SkillController::class)->except('update');
    Route::put('skills/{skill?}', [SkillController::class, 'update']);
    Route::apiResource('projects', ProjectController::class);
    Route::apiResource('profile-link', ProfileLinkController::class);

    Route::get('free-material', [FreeMaterialController::class, '__invoke']);

    Route::get('make-as-read/{taskFeedback}',[StudentEnrollmentController::class,'makeAsRead']);
    Route::get('make-all-read/{taskSubmission}',[StudentEnrollmentController::class,'makeAllRead']);
    Route::get('get-count-unread-feedback',[StudentEnrollmentController::class,'getCountUnReadFeedback']);
    Route::get('lectures/{lecture}', [StudentEnrollmentController::class, 'getLectureDetails']);
    #----- Student Home Routes
    Route::controller(StudentHomeController::class)->prefix('home')->group(function () {
        Route::get('/ranking', 'studentRanking');
        Route::get('/latest-feedback', 'latestFeedback');
        Route::get('/all-feedback', 'getAllFeedback');
        Route::get('/latest-feedback/{taskSubmission}/attachments', 'getFeedbackAttachments');
        Route::get('/latest-feedback/{taskSubmission}', 'getTaskAllFeedback');
        Route::get('/progress', 'studentProgress');
        Route::get('stats','stats');
        Route::get('lectures/stats',[StudentHomeController::class,'statsCharts']);
    });

    #----- Student Meeting Routes
    Route::get('home/upcoming-meetings', [StudentMeetingController::class, 'upcomingMeetings']);
    Route::get('home/todays-meetings', [StudentMeetingController::class, 'todaysMeetings']);

    #----- Student Profile Routes
    Route::controller(StudentProfileController::class)->prefix('profile')->group(function () {
        Route::get('/', 'showProfile');
        Route::post('/update', 'updateProfile');
    });

    #----- Student Enrollment Routes
    Route::controller(StudentEnrollmentController::class)->prefix('enrollments')->group(function () {
        Route::get('/', 'showStudentEnrollments');
        Route::get('/rounds/{round}/details', 'showStudentEnrollmentDetails');
        Route::post('/rounds/{round}/lectures/{lecture}/task', 'studentTaskSubmission');
    });

    #----- Student Transaction Routes
    Route::get('transactions', [StudentTransactionController::class, 'showStudentTransactionsAndInstallments']);

    #----- Ticket Routes
    // Route::get('tickets', [StudentTicketController::class, 'getAllTickets']);
    // Route::get('tickets/{ticket}', [StudentTicketController::class, 'showSingleTicket']);
    // Route::post('tickets/store', [StudentTicketController::class, 'storeTicket']);
    // Route::post('tickets/{ticket}/add-message', [StudentTicketController::class, 'addContentMessage']);



    Route::controller(TicketSystemController::class)->prefix('tickets')->group(function(){
        Route::get('/','index');
        Route::get('/{ticketSystem}','show');
        Route::post('/','store');
        Route::put('/{ticketSystem}','update');
        Route::delete('/{ticketSystem}','destroy');

        // Ticket Replies endpoints
        Route::get('/{ticket_id}/replies','getReplies');
        Route::post('/{ticket_id}/replies','storeReply');
        Route::put('/{ticket_id}/replies/{reply_id}','updateReply');
        Route::delete('/{ticket_id}/replies/{reply_id}','destroyReply');
    });


});
