<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string(column: 'name')->change()->nullable();
            $table->string('photo')->change()->nullable();
            $table->string('email')->change()->nullable();
            $table->string('password')->change()->nullable();
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('name')->change()->nullable(false);
            $table->string('photo')->change()->nullable(false);
            $table->string('email')->change()->nullable(false);
            $table->string('password')->change()->nullable(false);
            $table->string('title')->change()->nullable(false);
        });
    }
};
