<?php

use App\Enums\QuestionType;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('student_answers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('student_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('lecture_id')->constrained('lectures')->onDelete('cascade');
            $table->foreignId('question_id')->constrained('lecture_questions')->onDelete('cascade');
            $table->unsignedTinyInteger('question_type')->default(QuestionType::Reading);
            $table->longText('answer_content')->nullable();
            $table->foreignId('option_id')->nullable()->constrained('question_options')->onDelete('cascade');
            $table->boolean('is_correct')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('student_answers');
    }
};
