<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('course_enrollments', function (Blueprint $table) {
            // Drop old foreign key if it exists
            $table->dropForeign(['round_id']); // This assumes the FK already exists

            // Modify the column to be nullable
            $table->unsignedBigInteger('round_id')->nullable()->change();

            // Re-add the foreign key constraint with SET NULL on delete
            $table->foreign('round_id')
                  ->references('id')->on('rounds')
                  ->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::table('course_enrollments', function (Blueprint $table) {
            $table->dropForeign(['round_id']);
            $table->unsignedBigInteger('round_id')->nullable(false)->change();
            $table->foreign('round_id')->references('id')->on('rounds')->onDelete('cascade');
        });
    }
};
